import java.io.DataInputStream;
import java.util.Properties;


public class Utils {

	public static void setProxyConfiguration() {
		Properties props = props = System.getProperties(); 
		
		props.put("proxyHost","192.168.1.25");
		props.put("proxyPort","8080");
		
		System.setProperties(props);
	}
	
	public static byte[] decodeBase64String(final String content) throws Exception {
		return org.apache.axis2.util.Base64.decode(content);
	}

	public static String readFile(final String filename) throws Exception {
		StringBuffer sb = new StringBuffer();

		ClassLoader cl = Thread.currentThread().getContextClassLoader();
		DataInputStream dis = new DataInputStream(cl.getResourceAsStream(filename));

		byte[] buffer = new byte[4096];
		for (int len; (len = dis.read(buffer)) > 0;) {
			sb.append(new String(buffer, 0, len));
		}
		dis.close();

		return sb.toString();
	}

	public static byte[] readBase64File(final String filename) throws Exception {
		return (decodeBase64String(readFile(filename)));
	}

	public static String readXmlFile(final String filename) throws Exception {
		return readFile(filename);
	}

}
